function initBurgerMenu() {
    const burgerIcon = document.querySelector('.burger-icon');
    const mobileNav = document.querySelector('.mobile-nav');
    
    if (!burgerIcon || !mobileNav) {
        console.error('Элементы бургера не найдены');
        return;
    }
    
    const menuOverlay = document.createElement('div');
    menuOverlay.className = 'menu-overlay';
    document.body.appendChild(menuOverlay);
    
    function toggleMenu() {
        burgerIcon.classList.toggle('active');
        mobileNav.classList.toggle('active');
        menuOverlay.classList.toggle('active');
        document.body.style.overflow = burgerIcon.classList.contains('active') ? 'hidden' : '';
    }
    
    burgerIcon.addEventListener('click', function(e) {
        e.stopPropagation();
        toggleMenu();
    });
    
    menuOverlay.addEventListener('click', toggleMenu);
    
    mobileNav.querySelectorAll('a').forEach(link => {
        link.addEventListener('click', toggleMenu);
    });
    
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && burgerIcon.classList.contains('active')) {
            toggleMenu();
        }
    });
}

document.addEventListener('DOMContentLoaded', initBurgerMenu);
document.addEventListener('DOMContentLoaded', function() {
    const burgerIcon = document.querySelector('.burger-icon');
    const mobileNav = document.querySelector('.mobile-nav');
    const menuOverlay = document.querySelector('.menu-overlay');
    
    if (burgerIcon && mobileNav) {
        burgerIcon.addEventListener('click', function(e) {
            e.stopPropagation();
            this.classList.toggle('active');
            mobileNav.classList.toggle('active');
            if (menuOverlay) {
                menuOverlay.classList.toggle('active');
            }
            document.body.style.overflow = this.classList.contains('active') ? 'hidden' : '';
        });
        
        mobileNav.querySelectorAll('a').forEach(link => {
            link.addEventListener('click', function() {
                burgerIcon.classList.remove('active');
                mobileNav.classList.remove('active');
                if (menuOverlay) menuOverlay.classList.remove('active');
                document.body.style.overflow = '';
            });
        });
        
        if (menuOverlay) {
            menuOverlay.addEventListener('click', function() {
                burgerIcon.classList.remove('active');
                mobileNav.classList.remove('active');
                this.classList.remove('active');
                document.body.style.overflow = '';
            });
        }
        
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && mobileNav.classList.contains('active')) {
                burgerIcon.classList.remove('active');
                mobileNav.classList.remove('active');
                if (menuOverlay) menuOverlay.classList.remove('active');
                document.body.style.overflow = '';
            }
        });
    }
    
    window.addEventListener('scroll', function() {
        const header = document.querySelector('header');
        if (window.scrollY > 50) {
            header.style.padding = '15px 5%';
            header.style.boxShadow = '0 5px 15px rgba(0, 0, 0, 0.1)';
        } else {
            header.style.padding = '20px 5%';
            header.style.boxShadow = '0 2px 10px rgba(0, 0, 0, 0.1)';
        }
    });
    
});

function initClickOnlyServices() {
    const serviceBlocks = document.querySelectorAll('.service-block');
    const indicators = document.querySelectorAll('.indicator');
    const totalBlocks = serviceBlocks.length;
    
    if (totalBlocks === 0) return;
    
    let currentBlock = 0;
    let isAnimating = false;
    
    function switchToBlock(index) {
        if (isAnimating || index === currentBlock || index < 0 || index >= totalBlocks) {
            return;
        }
        
        isAnimating = true;
        
        serviceBlocks[currentBlock].classList.remove('active');
        indicators[currentBlock].classList.remove('active');
        
        setTimeout(() => {
            currentBlock = index;
            serviceBlocks[currentBlock].classList.add('active');
            indicators[currentBlock].classList.add('active');
            
            isAnimating = false;
        }, 300); 
    }
    
    indicators.forEach((indicator, index) => {
        indicator.addEventListener('click', (e) => {
            e.stopPropagation(); 
            switchToBlock(index);
        });
        
        indicator.setAttribute('title', `Услуга ${index + 1}`);
    });
    
    document.addEventListener('keydown', (e) => {
        const servicesSection = document.getElementById('services');
        const rect = servicesSection.getBoundingClientRect();
        
        if (rect.top < window.innerHeight && rect.bottom > 0) {
            if (e.key === 'ArrowRight' || e.key === 'ArrowDown') {
                e.preventDefault();
                const nextIndex = (currentBlock + 1) % totalBlocks;
                switchToBlock(nextIndex);
            } else if (e.key === 'ArrowLeft' || e.key === 'ArrowUp') {
                e.preventDefault();
                const prevIndex = (currentBlock - 1 + totalBlocks) % totalBlocks;
                switchToBlock(prevIndex);
            }
        }
    });
    
    serviceBlocks[0].classList.add('active');
    indicators[0].classList.add('active');
    
    setTimeout(() => {
        const activeBlock = serviceBlocks[0];
        if (activeBlock) {
            const elementsToAnimate = activeBlock.querySelectorAll(
                'h2, h3, p, .btn-details, .oval-btn'
            );
            
            elementsToAnimate.forEach((el, i) => {
                el.style.opacity = '1';
                el.style.transform = 'translate(0, 0)';
            });
        }
    }, 100);
}

document.addEventListener('DOMContentLoaded', function() {
    initClickOnlyServices();
});

window.addEventListener('scroll', function() {
    const header = document.querySelector('header');
    if (window.scrollY > 50) {
        header.style.padding = '15px 5%';
        header.style.boxShadow = '0 5px 15px rgba(0, 0, 0, 0.1)';
    } else {
        header.style.padding = '20px 5%';
        header.style.boxShadow = '0 2px 10px rgba(0, 0, 0, 0.1)';
    }
});

document.addEventListener('DOMContentLoaded', function() {
    const sliders = document.querySelectorAll('.slider');
    
    sliders.forEach(slider => {
        const slides = slider.querySelectorAll('.slide');
        const prevBtn = slider.parentElement.querySelector('.slider-prev');
        const nextBtn = slider.parentElement.querySelector('.slider-next');
        let currentSlide = 0;
        
        function showSlide(index) {
            slides.forEach(slide => slide.classList.remove('active'));
            slides[index].classList.add('active');
            currentSlide = index;
        }
        
        function nextSlide() {
            let nextIndex = (currentSlide + 1) % slides.length;
            showSlide(nextIndex);
        }
        
        function prevSlide() {
            let prevIndex = (currentSlide - 1 + slides.length) % slides.length;
            showSlide(prevIndex);
        }
        
        if (prevBtn && nextBtn) {
            prevBtn.addEventListener('click', prevSlide);
            nextBtn.addEventListener('click', nextSlide);
        }
        
        setInterval(nextSlide, 5000);
    });
    
    const phoneInput = document.querySelector('.phone-input');
    if (phoneInput) {
        phoneInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length > 0) {
                if (value.length <= 3) {
                    value = value;
                } else if (value.length <= 6) {
                    value = value.slice(0, 3) + '-' + value.slice(3);
                } else if (value.length <= 8) {
                    value = value.slice(0, 3) + '-' + value.slice(3, 6) + '-' + value.slice(6);
                } else {
                    value = value.slice(0, 3) + '-' + value.slice(3, 6) + '-' + value.slice(6, 8) + '-' + value.slice(8, 10);
                }
            }
            e.target.value = value;
        });
    }
    
    document.querySelectorAll('nav a').forEach(anchor => {
        anchor.addEventListener('click', function(e) {
            e.preventDefault();
            const targetId = this.getAttribute('href');
            const targetElement = document.querySelector(targetId);
            
            if (targetElement) {
                window.scrollTo({
                    top: targetElement.offsetTop - 80,
                    behavior: 'smooth'
                });
            }
        });
    });
    
    const consultationForm = document.querySelector('.consultation-form');
    if (consultationForm) {
        consultationForm.addEventListener('submit', function(e) {
            e.preventDefault();
            alert('Спасибо за заявку! Мы свяжемся с вами в ближайшее время.');
            consultationForm.reset();
        });
    }
});
document.addEventListener('DOMContentLoaded', function() {
    const btn = document.querySelector('.btn-yes');
    const form = document.querySelector('.consultation-form-container');
    
    if (btn && form) {
        btn.addEventListener('click', function() {
            form.classList.toggle('show');
            
            if (form.classList.contains('show')) {
                this.textContent = 'Скрыть форму';
                setTimeout(() => {
                    form.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }, 300);
            } else {
                this.textContent = 'Да, хочу';
            }
        });
    }
});

function initMobileMenu() {
    const burgerIcon = document.querySelector('.burger-icon');
    const mobileNav = document.querySelector('.mobile-nav');
    const menuOverlay = document.querySelector('.menu-overlay') || document.createElement('div');
    
    if (!menuOverlay.parentNode) {
        menuOverlay.className = 'menu-overlay';
        document.body.appendChild(menuOverlay);
    }
    
    function toggleMenu() {
        burgerIcon.classList.toggle('active');
        mobileNav.classList.toggle('active');
        menuOverlay.classList.toggle('active');
        document.body.style.overflow = mobileNav.classList.contains('active') ? 'hidden' : '';
    }
    
    burgerIcon.addEventListener('click', function(e) {
        e.stopPropagation();
        toggleMenu();
    });
    
    menuOverlay.addEventListener('click', toggleMenu);
    
    mobileNav.querySelectorAll('a').forEach(link => {
        link.addEventListener('click', toggleMenu);
    });
    
    window.addEventListener('resize', function() {
        if (window.innerWidth > 768 && mobileNav.classList.contains('active')) {
            toggleMenu();
        }
    });
}

document.addEventListener('DOMContentLoaded', function() {
    initMobileMenu();
});